definition module deltaSystem

from StdString import String

/*	Keyboard constants */

UpKey     :== '\036'
DownKey   :== '\037'
LeftKey   :== '\034'
RightKey  :== '\035'
PgUpKey   :== '\013'
PgDownKey :== '\014'
BeginKey  :== '\001'
EndKey    :== '\004'
BackSpKey :== '\010'
DelKey    :== '\177'
TabKey    :== '\011'
ReturnKey :== '\015'
EnterKey  :== '\003'
EscapeKey :== '\033'
HelpKey   :== '\005'


/*	Constants to check which of the Modifiers is down. */

ShiftOnly   :== (True,False,False,False)
OptionOnly  :== (False,True,False,False)
CommandOnly :== (False,False, True,True)
ControlOnly :== (False,False, True,True)


/* The functions HomePath and ApplicationPath prefix the
   filename given to them with the full pathnames of the 'home'
   and 'application' directory.
   These functions have been added for compatibility with the
   Sun version of the Clean system. In the 'home' directory
   settings-files (containing preferences, options etc.) should
   be stored. In the 'application' directory (i.e. the
   directory in which the application resides) files that are
   used read-only by the application (such as help files) should
   be stored.
   On the Macintosh these functions just return the filename
   given to them, which means that the file will be stored in
   the same folder as the application.
   On Windows 95 these functions prefix the filename with the
   full path of the application.
*/

HomePath :: !String -> String
ApplicationPath :: !String -> String

DirSeparator :== '\\'	// Separator between folder- and
						// filenames in a pathname


/*	Maximum ranges of window PictureDomains:
		MaxScrollWindowSize yields the range at which scrollbars
			are inactive.
		MaxFixedWindowSize yields the range at which the window
			does not change into a ScrollWindow.
*/

MaxScrollWindowSize :: (!Int,!Int)

MaxFixedWindowSize :: (!Int,!Int)

MMToHorPixels   :: !Real -> Int
MMToVerPixels   :: !Real -> Int
InchToHorPixels :: !Real -> Int
InchToVerPixels :: !Real -> Int
